
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1270.C - Message 1270 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1270 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

// Global data for dr parameters
extern tUSHORT DRSpeedSigma;    //standard deviation
extern tUSHORT DRSpeedTimeTag;  //resolution
extern tUSHORT DRSpeedLatency;  //latency

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1270 message from the ZMsgBuf.
//
void Dec1270(tMSGBUF *ZMsgBuf, tMSG1270 *Msg)
{
; // whatever
}                                      

end not needed yet */
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1270 message in the ZMsgBuf.
//
void Bld1270(tMSGBUF *ZMsgBuf, tMSG1270 *Msg)
{
 
   // build the header in the buffer
   PutShort  (0x81FF                      , ZMsgBuf, 1);     // message preamble
   PutShort  (1270                        , ZMsgBuf, 2);     // message number
   PutShort  (9                           , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                       , ZMsgBuf, 4);     // message ack/nack request

   PutShort  (Msg->SequenceNumber         , ZMsgBuf, 6);    // ND   
   PutUShort (Msg->DRSpeedSigma           , ZMsgBuf, 7);    // E-02 
   PutUShort (Msg->DRSpeedTimeTag         , ZMsgBuf, 8);    // E-02 
   PutUShort (Msg->DRSpeedLatency         , ZMsgBuf, 9);    // E-02 
   PutUShort (Msg->Reserved[0]            , ZMsgBuf, 10);   // ND 
   PutUShort (Msg->Reserved[1]            , ZMsgBuf, 11);   // E-05 
   PutUShort (Msg->Reserved[2]            , ZMsgBuf, 12);   // E-02 
   PutUShort (Msg->Reserved[3]            , ZMsgBuf, 13);   // ND 
   PutUShort (Msg->Reserved[4]            , ZMsgBuf, 14);   // ND 

   // fill in Global data for dr parameters
   DRSpeedSigma   = Msg->DRSpeedSigma;    //standard deviation
   DRSpeedTimeTag = Msg->DRSpeedTimeTag;  //resolution
   DRSpeedLatency = Msg->DRSpeedLatency;

}                                            


/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1270 message from the ZMsgBuf.
//
void Show1270(tMSG1270 *Msg)
{
; // whatever
}                                                 

end not needed yet */
                                      
                                           
